#ifndef PARSER_ATP_SST_SPECIALDATA_H
#define PARSER_ATP_SST_SPECIALDATA_H


#include "msg_defs.h"
#include "SST_SEP_TST.h"
#include "sst_errors.h"
#include "sst_sep_errors.h"
typedef enum
{

    CHALLENGE_BUFF_SIZE_OFFSET                  = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 0),
    AESKEY_TYPE1_OFFSET                         = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 1),
    AESKEY_TYPE2_OFFSET                         = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 2),
    AESKEY_TYPE_TEMP_OFFSET                     = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 3),
    KEY_SIZE_OFFSET                             = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 4),
    OPERATION_MODE_OFFSET                       = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 5),
    START_SPECIAL_DATA_AES_BUFFERS_OFFSET       = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 7)
}SpecialDataOpAES_Parameters_Offsets;
/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_SST_SpecialDataOpAES      
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application 
* of insertion, generation, reading, deletion, and usage of an AES symmetric key
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_SST_PARSER_SpecialDataOpAES(DxUint32_t* msg);

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_SST_SpecialDataOpDES      
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application 
* of insertion, generation, reading, deletion, and usage of an DES symmetric key
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_SST_PARSER_SpecialDataOpDES(DxUint32_t* msg);
/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_SST_SpecialDataOpHMAC
*
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* Test the insertion, generation, reading, deletion, and usage of a HMAC key.
*
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. allocate memory buffers
* 2. extract parameters from the message 
* 3. call QA SEP function
* 4. free allocated buffers
* 5. end SEP message and return
******************************************************************************/ 

DxUint32_t DX_SEP_SST_PARSER_SpecialDataOpHMAC(DxUint32_t* msg);
/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_SST_SpecialDataOpRSA
*
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* Test the insertion, generation, reading, deletion, and usage of a HMAC key.
*
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. allocate memory buffers
* 2. extract parameters from the message 
* 3. call QA SEP function
* 4. free allocated buffers
* 5. end SEP message and return
******************************************************************************/ 

DxUint32_t DX_SEP_SST_PARSER_SpecialDataOpRSA(DxUint32_t* msg);
#endif
